//
//  $Id: WXKContactWindowController.m 109 2009-06-27 16:24:38Z fujidana $
//  Copyright 2008 FUJIDANA. All rights reserved.
//
// Redistribution and use in source and binary forms, with or without
// modification, are permitted provided that the following conditions
// are met:
// 1. Redistributions of source code must retain the above copyright
//    notice, this list of conditions and the following disclaimer.
// 2. Redistributions in binary form must reproduce the above copyright
//    notice, this list of conditions and the following disclaimer in the
//    documentation and/or other materials provided with the distribution.
//
// THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
// IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
// OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
// IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT, INDIRECT,
// INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT
// NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE,
// DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY
// THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
// (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
// THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.


#import "WXKContactWindowController.h"
#import "FJNIndexedContentArrayController.h"
#import "WXKAddressCard.h"
#import "WXKABPeoplePickerWindowController.h"


@implementation WXKContactWindowController

- (id)init
{
	self = [super initWithWindowNibName:@"ContactWindow" storeDirectory:@"Kyopon Utilities" filename:@"contacts.wxkxml" type:NSXMLStoreType];
	return self;
}

- (void)windowWillLoad
{
	[super windowWillLoad];
	
	[self setWindowFrameAutosaveName:@"ContactWindowFrame"];
}

- (void)windowDidLoad
{
	[super windowDidLoad];
	
	// Check wheter bookmark folders exist in the managed object context. If they ddoes not exists, create new folders.
	NSMutableArray *dictionaries = [NSMutableArray arrayWithCapacity:20];
	NSDictionary *keyedValues;
	int i;
	for (i = 0; i < 20; i++)
	{
		keyedValues = [NSDictionary dictionaryWithObjectsAndKeys:
					   [NSNumber numberWithLong:i], @"order",
					   [NSString stringWithFormat:@"%02d", i], @"title",
					   nil];
		[dictionaries addObject:keyedValues];
	}
	[[self containerArrayController] initializedObjectsWithDictionaries:dictionaries];
	
	[[self contentArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"card", @"AddressLocalizable", @"childEntityName")];
	[[self containerArrayController] setLocalizedEntityName:NSLocalizedStringFromTable(@"group", @"AddressLocalizable", @"parentEntityName")];
	[(FJNIndexedContentArrayController *)[self contentArrayController] setIndexerEntityName:@"ContactIndexer"];
	[[self contentArrayController] setEntityImageName:@"ToolbarContactIcon.tiff"];
	
	[self setupToolbarWithIdentifier:@"KyoponContactsToolbarIdentifier"];
}

#pragma mark IBAction methods

- (IBAction)importFromAddressBook:(id)sender
{
	WXKABPeoplePickerWindowController *windowController = [WXKABPeoplePickerWindowController sharedWindowController];
	[windowController beginSheetModalForWindow:[self window]
								 modalDelegate:self
								didEndSelector:@selector(peoplePickerSheetDidEnd:returnCode:contextInfo:)
								   contextInfo:NULL];
}

- (void)peoplePickerSheetDidEnd:(NSWindow *)window returnCode:(int)returnCode contextInfo:(void *)contextInfo
{
	if (returnCode == NSOKButton)
	{
		WXKABPeoplePickerWindowController *windowController = [window windowController];
		NSEnumerator *enumerator = [[windowController selectedPeople] objectEnumerator];
		id abPerson;
		while (abPerson = [enumerator nextObject])
		{
			NSDictionary *dictionary = [WXKAddressCard dictionaryWithABPerson:abPerson];
			if (dictionary)
			{
				NSManagedObject *object = [[self contentArrayController] newObject];
				[[self contentArrayController] addObject:object];
				[object setValuesForKeysWithDictionary:dictionary];
			}
		}
	}
}

- (IBAction)copy:(id)sender
{
//	NSLog(@"%@", [[[self contentArrayController] selection] valueForKeyPath:@"phoneNumbers.value"]);
//	
//	NSPredicate *predicate = [NSPredicate predicateWithFormat:@"ANY phoneNumbers.value == %@", @"029"];
//	NSLog(@"%@", [[[self contentArrayController] selectedObjects] filteredArrayUsingPredicate:predicate]);
}

//- (IBAction)paste:(id)sender
//{
//}

- (BOOL)validateUserInterfaceItem:(id <NSValidatedUserInterfaceItem>)anItem
{
	if ([anItem action] == @selector(copy:))
	{
		if ([[self window] firstResponder] == [[self contentArrayController] tableView] &&
			[[[self contentArrayController] selectedObjects] count] > 0)
		{
			return YES;
		}
		return NO;
	}
	if ([anItem action] == @selector(paste:))
	{
		if ([[self window] firstResponder] == [[self contentArrayController] tableView])// &&
//			[[NSPasteboard generalPasteboard] availableTypeFromArray:[NSArray arrayWithObject:NSVCardPboardType]])
		{
			NSLog(@"%@", [[NSPasteboard generalPasteboard] types]);
		}
		return NO;
	}
	return [super validateUserInterfaceItem:anItem];
}


#pragma mark Methods delegated by NSToolbar

//- (NSToolbarItem *)toolbar:(NSToolbar *)toolbar itemForItemIdentifier:(NSString *)itemIdentifier willBeInsertedIntoToolbar:(BOOL)flag
//{
//	NSToolbarItem *toolbarItem = [super toolbar:toolbar itemForItemIdentifier:itemIdentifier willBeInsertedIntoToolbar:flag];
//	return toolbarItem;
//}

- (NSArray *)toolbarDefaultItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarDeleteContentIdentifier,
			NSToolbarSeparatorItemIdentifier,
			WXKToolbarReceiveItemIdentifier,
			WXKToolbarSendItemIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier,
			FJNContainableToolbarSearchContentIdentifier,
			nil];
}

- (NSArray *)toolbarAllowedItemIdentifiers:(NSToolbar *)toolbar
{
	return [NSArray arrayWithObjects:
			FJNContainableToolbarNewContentIdentifier,
			FJNContainableToolbarDeleteContentIdentifier,
			FJNContainableToolbarPreviousContentIdentifier,
			FJNContainableToolbarNextContentIdentifier,
			FJNContainableToolbarPreviousContainerIdentifier,
			FJNContainableToolbarNextContainerIdentifier,
			FJNContainableToolbarDeselectSortIdentifier,
			FJNContainableToolbarSearchContentIdentifier,
			FJNIndexableToolbarReindexSelectionIdentifier,
			WXKToolbarReceiveItemIdentifier,
			WXKToolbarSendItemIdentifier,
			// WXKToolbarAddressUtilityItemIdentifier,
			WXKToolbarBookmarkUtilityItemIdentifier,
			WXKToolbarFileUtilityItemIdentifier,
			WXKToolbarMailUtilityItemIdentifier,
			NSToolbarPrintItemIdentifier,
			// NSToolbarShowColorsItemIdentifier,
			// NSToolbarShowFontsItemIdentifier,
			NSToolbarCustomizeToolbarItemIdentifier,
			NSToolbarSeparatorItemIdentifier,
			NSToolbarSpaceItemIdentifier,
			NSToolbarFlexibleSpaceItemIdentifier,
			nil];
}

@end
